/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.redpxnda.respawnobelisks.compat.jei.Plugin;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ObeliskInteractionCategory
implements IRecipeCategory<InteractionRecipe> {
    public static final ResourceLocation JEI_BACKGROUND = new ResourceLocation("respawnobelisks", "textures/gui/jei_category.png");
    private final IDrawable background;
    private final IDrawable icon;

    public ObeliskInteractionCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(JEI_BACKGROUND, 0, 0, 116, 32).setTextureSize(128, 128).build();
        this.icon = helper.createDrawableItemStack(((Item)ModRegistries.RESPAWN_OBELISK_ITEM.get()).m_7968_());
    }

    public RecipeType<InteractionRecipe> getRecipeType() {
        return Plugin.INTERACTION_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"text.respawnobelisks.jei.interaction_title");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InteractionRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 7, 8);
        inputSlot.addItemStack(recipe.input);
        IRecipeSlotBuilder obeliskSlot = builder.addSlot(RecipeIngredientRole.CATALYST, 53, 8);
        obeliskSlot.addItemStack(recipe.obelisk);
    }

    public void draw(InteractionRecipe recipe, IRecipeSlotsView slotsView, PoseStack stack, double mouseX, double mouseY) {
        double charge = Mth.m_14008_((double)recipe.charge, (double)0.0, (double)100.0) / 100.0;
        RenderSystem.m_157456_((int)0, (ResourceLocation)JEI_BACKGROUND);
        GuiComponent.m_93143_((PoseStack)stack, (int)98, (int)4, (int)0, (float)0.0f, (float)32.0f, (int)16, (int)22, (int)128, (int)128);
        GuiComponent.m_93143_((PoseStack)stack, (int)103, (int)(7 + Mth.m_14165_((double)(14.0 * (1.0 - charge)))), (int)0, (float)5.0f, (float)(57 + Mth.m_14165_((double)(14.0 * (1.0 - charge)))), (int)6, (int)Mth.m_14165_((double)(14.0 * charge)), (int)128, (int)128);
    }

    public List<Component> getTooltipStrings(InteractionRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 98.0 && mouseX <= 113.0 && mouseY >= 4.0 && mouseY <= 25.0) {
            return List.of(Component.m_237113_((String)(recipe.charge + " ")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"text.respawnobelisks.jei.charge_text").m_130940_(ChatFormatting.DARK_GRAY)));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public static class InteractionRecipe {
        private final ItemStack input;
        private final ItemStack obelisk;
        private final double charge;

        public InteractionRecipe(ItemStack input, ItemStack obelisk, double charge) {
            this.input = input;
            this.obelisk = obelisk;
            this.charge = charge;
        }
    }
}

